var SaveSd = $.extend(GameState, {
    init: function (cookieId) {
        //Set storage identifier
        this.setCookieIdentifier(cookieId);

        //Load sudoku game
        this.loadSudoku();

        //Bind functionality to save button
        $(this.defaults.saveButton).click(function () {
            SaveSd.saveSudoku();
        });

        //"CLEAR ALL" BUTTON CLICK
        $(Puzzle.defaults.clearButton).click(function () {
            //GS BUG# 2314
            $.confirm({
                title: '',
                content: 'Are you sure you want to clear the puzzle?',
                buttons: {
                    Ok: function () {
                        TrackPuzzle.sendPuzzleStatistics(true);
                        GameState.clearGameState();

                        if (puzzleTimer)
                            puzzleTimer.reset();

                        //Clear cells
                        $(Puzzle.defaults.cellsId).each(function () {
                            if (!$(this).hasClass(Puzzle.defaults.hintCellClass))
                                $(this).children(Puzzle.defaults.cellInputId).html("");

                            $(this).removeClass(Puzzle.defaults.invalidCellClass);
                            $(this).removeClass(Puzzle.defaults.selectedClass);
                            $(this).removeClass(Puzzle.defaults.selectedGroupClass);
                        });
                    },
                    Cancel: function () {
                        //close
                    }
                }
            });
            //GS BUG# 2314
            
//            if (confirm("Are you sure you want to clear the puzzle?")) {
//                TrackPuzzle.sendPuzzleStatistics(true);
//                GameState.clearGameState();
//
//                if(puzzleTimer)
//                    puzzleTimer.reset();
//                
//                //Clear cells
//                $(Puzzle.defaults.cellsId).each(function() {
//                    if (!$(this).hasClass(Puzzle.defaults.hintCellClass))
//                        $(this).children(Puzzle.defaults.cellInputId).html("");
//                    
//                    $(this).removeClass(Puzzle.defaults.invalidCellClass);
//                    $(this).removeClass(Puzzle.defaults.selectedClass);
//                    $(this).removeClass(Puzzle.defaults.selectedGroupClass);
//                });
//            }
        });
    },
    saveSudoku: function () {

        if (!Sudoku.checkAnswers())
        {
            var cookieString = "";
            var cells = $(Puzzle.defaults.gridId).find(Puzzle.defaults.cellsId);

            for (var i = 0; i < cells.length; i++)
            {
                var cellInput = $(cells[i]).children(Puzzle.defaults.cellInputId).html();

                if (cellInput && cellInput.length > 0)
                    cookieString += cellInput[0];
                else
                    cookieString += this.defaults.blankAnswer;
            }

            //Set cookie
            this.setGameState(cookieString);

            //Notify user that game is saved
            $(this.defaults.gameStateLabel).html("Game saved");

            //Clear any existing timeout functions
            if (this.defaults.timeoutId)
                clearTimeout(this.defaults.timeoutId);

            //Set timeout to clear content
            setTimeout(function () {
                $(SaveSd.defaults.gameStateLabel).html("");
            }, SaveSd.defaults.timeoutDuration);
        }
    },
    loadSudoku: function () {
        var cookieString = this.getGameState();
        var cells = $(Puzzle.defaults.gridId).find(Puzzle.defaults.cellsId);

        if (cookieString && cookieString.length)
        {
            for (var i = 0; i < cookieString.length; i++)
            {
                if (cookieString[i] == this.defaults.blankAnswer)
                    $(cells[i]).children(Puzzle.defaults.cellInputId).html("");
                else
                    $(cells[i]).children(Puzzle.defaults.cellInputId).html(cookieString[i]);
            }
        }
    }
});