var TrackSd = $.extend(TrackPuzzle, {
    getCellNumber: function(cell) {
        return $(cell).attr("id");
    },
    saveCellStartTime: function(cell) {
        if (!this.isTrackingActive)
            return;
        
        //End the timing for the last cell
        this.endCellTracking();
        
        //Set start time for current
        var cellNumber = this.getCellNumber(cell);
        if (this.cellTimes[cellNumber])
        {
            this.cellTimes[cellNumber].start = this.getCurrentTime();
        }
        else
        {
            this.cellTimes[cellNumber] = {
                start: this.getCurrentTime()
            };
        }
        
        //Set current cell as last selected
        this.lastSelectedCell = cell;
    },
    endCellTracking: function() {
        if (!this.isTrackingActive)
            return;
        
        //End the timing for the last cell
        if (this.lastSelectedCell)
        {
            var cellNumber = this.getCellNumber(this.lastSelectedCell);
            if (this.cellTimes[cellNumber] && this.cellTimes[cellNumber].start)
            {
                var timeSpent = this.getCurrentTime() - this.cellTimes[cellNumber].start;
                
                if (timeSpent > 0)
                {
                    //If time spent is positive, append it
                    if (this.cellTimes[cellNumber].time_spent)
                        this.cellTimes[cellNumber].time_spent += timeSpent;
                    else
                        this.cellTimes[cellNumber].time_spent = timeSpent;

                    this.saveStat('cell_time', cellNumber, this.cellTimes[cellNumber].time_spent, true);
                }
                else
                {
                    //If time spent is negative, log error message
                    //console.log("Time spent for the cell is negative! Cell: " + cellNumber);
                }
            }
        }
    },
    
    endGame: function() {

        this.endCellTracking();//endClueTracking();
    },
    
    /*
    savePuzzleStatistics: function() {
        if (!this.isTrackingActive)
            return;
        
        //End game timing and puzzle completion tracking
        this.endGame();
        //End the timing for the last cell
        this.endCellTracking();
        

        $.ajax({
            contentType : "application/x-www-form-urlencoded; charset=utf-8",
            dataType : "json",
            type : "POST", 
            async : false,
            timeout: 5000,
            url : TrackSd.serviceURL,
            data : {
                puzzle_id : TrackSd.puzzleId,
                game_duration : TrackSd.gameDuration.duration,
                game_completion : TrackSd.puzzleCompletion,
                cells_duration : JSON.stringify(TrackSd.cellTimes)
            },
            success: function(msg)
            {
                //console.log(msg);
            },
            complete: function()
            {
            }
        });
    },*/
    lastSelectedCell: undefined,
    cellTimes: {}
});