var SharePuzzle = {
    init: function(config) {
        if (config) {
            this.fbAppId = config.fbAppId;
            this.baseURL = config.baseURL;
            this.puzzleShareLink = config.puzzleShareLink;
            this.puzzleShareText = config.puzzleShareText;
            this.puzzleType = config.puzzleType;
            this.puzzleShareCaption = "I played this " + this.puzzleType + "!";
            this.shareType = config.shareType == undefined ? "time" : config.shareType;
        }

        //Link is required for FB Share, so check if it's empty
        if (!this.puzzleShareLink || this.puzzleShareLink.length === 0)
            this.puzzleShareLink = document.URL;
        
        $("#btn-facebook-score-share").on("click", function() {
            submitFlags |= SUBMIT_FLAG_FACEBOOK;
            var scoreText = SharePuzzle.getPuzzleResult();
            SharePuzzle.shareScoreOnFacebook(scoreText);
        });
        
        $("#btn-twitter-score-share").on("click", function() {
            submitFlags |= SUBMIT_FLAG_TWITTER;
            var scoreText = SharePuzzle.getPuzzleResult();
            SharePuzzle.shareScoreOnTwitter(scoreText);
        });
        
        $("#btn-email-score-share").on("click", function() {
            submitFlags |= SUBMIT_FLAG_MAIL;
            var scoreText = SharePuzzle.getPuzzleResult();
            SharePuzzle.shareScoreViaEmail(scoreText);
        });
    },
    getPuzzleResult: function() {
        var message = "I just played this " + this.puzzleType + ": " + this.puzzleShareLink;

        if(this.shareType === "score" && puzzleScore && leaderboardOrderString)
        {
            message += " I made it to " + leaderboardOrderString + " place with a score of " + puzzleScore.getScore() + "!";
        }
        else if(this.shareType === "mixed" && leaderboardOrderString && puzzleScore && puzzleTimer)
        {
            if (puzzleTimer.isCountdown())
            	message += " I made it to " + leaderboardOrderString + " place with a score of " + puzzleScore.getScore() + " with " + puzzleTimer.getFormattedTimeString() + " left!";
            else
            	message += " I made it to " + leaderboardOrderString + " place with a score of " + puzzleScore.getScore() + " in " + puzzleTimer.getFormattedTimeString() + "!";
        }
        else if (puzzleTimer && leaderboardOrderString)
        {
            if (puzzleTimer.isCountdown())
                message += " I made it to " + leaderboardOrderString + " place by finishing with " + puzzleTimer.getFormattedTimeString() + " left!";
            else
                message += " I made it to " + leaderboardOrderString + " place by finishing in " + puzzleTimer.getFormattedTimeString() + "!";
        }
        
        return message;
    },
    shareOnFacebook: function(shareText, scoreText) {
        if (!shareText)
            shareText = this.puzzleShareText;
    //GS BUG #1065    
        var postUrl = "https://www.facebook.com/dialog/feed?" +
            "app_id=" + encodeURIComponent(this.fbAppId) + "&" +
            "link=" + encodeURIComponent(this.puzzleShareLink) + "&" +
            "name=" + encodeURIComponent(this.puzzleShareCaption) + "&" +
            "caption=" + encodeURIComponent(this.puzzleShareCaption) + "&" +
            "description=" + encodeURIComponent(shareText);
    //GS BUG #1065
    
//            "redirect_uri=" + encodeURIComponent(this.puzzleShareLink);
        
//        if (scoreText)
//            postUrl += "&message=" + scoreText;
//        
//        if (scoreText) {
//            postUrl = 'https://www.facebook.com/sharer/sharer.php?m2w&s=100&' + 
//                'p[title]=' + encodeURIComponent(this.puzzleShareCaption) + 
//                '&p[summary]=' + encodeURIComponent(shareText + scoreText) + 
//                '&p[url]=' + encodeURIComponent(this.puzzleShareLink);
//        }
//            
//        else {
//            postUrl = 'https://www.facebook.com/sharer/sharer.php?m2w&s=100&' + 
//                'p[title]='+encodeURIComponent(this.puzzleShareCaption) + 
//                '&p[summary]=' + encodeURIComponent(shareText) + 
//                '&p[url]=' + encodeURIComponent(this.puzzleShareLink);
//        }
        
        window.open(postUrl, "_blank");
    },
    shareOnTwitter: function(shareText) {
        if (!shareText)
            shareText = this.puzzleShareText;
        
        var postUrl = "https://twitter.com/share?text=" + encodeURIComponent(shareText) + "&url=";
        window.open(postUrl, "_blank");
    },
    shareViaEmail: function(shareText) {
        if (!shareText)
            shareText = this.puzzleShareText;
        
        var mailTo = encodeURIComponent("Your Friend's Email");
        var mailSubject = encodeURIComponent(this.puzzleShareCaption);
        var mailBody = encodeURIComponent(shareText);            
        window.open('mailto:' + mailTo + '?subject=' + mailSubject + '&body=' + mailBody, "_self");
    },
    shareScoreOnFacebook: function(score) {
        var shareText = this.puzzleShareText + " " + score;
        this.shareOnFacebook(shareText);
    },
    shareScoreOnTwitter: function(score) {
        var shareText = this.puzzleShareText + " " + score;
        this.shareOnTwitter(shareText);
    },
    shareScoreViaEmail: function(score) {
        var shareText = this.puzzleShareText + " " + score;
        this.shareViaEmail(shareText);
    },

    getShares: function()
    {
        return this.shares;
    },

    fbAppId: undefined,
    puzzleShareLink: undefined,
    puzzleShareText: undefined,
    puzzleShareCaption: undefined,
    baseURL: undefined,
    shareType : "time",
};