var SaveCs = $.extend(GameState, {
    init: function (cookieId) {
        //Set storage identifier
        this.setCookieIdentifier(cookieId);

        //Load crossword game
        this.loadCrossword();

        //Bind functionality to save button
        $(this.defaults.saveButton).click(function () {
            SaveCs.saveCrossword();
        });

        //"CLEAR ALL" BUTTON CLICK
        $(Puzzle.defaults.clearButton).click(function () {
            //GS BUG# 2314
            $.confirm({
                title: '',
                content: 'Are you sure you want to clear the puzzle?',
                buttons: {
                    Ok: function () {
                        TrackPuzzle.sendPuzzleStatistics(true);
                        if (puzzleTimer)
                            puzzleTimer.reset();

                        GameState.clearGameState();
                        $(Puzzle.defaults.cellsId).not(Puzzle.defaults.hintCellId).children(Puzzle.defaults.cellInputId).each(function () {
                            $(this).html("");
                            var parentCell = $(this).parents(Puzzle.defaults.cellsId);
                            parentCell.removeClass(Puzzle.defaults.invalidCellClass);
                            parentCell.removeClass(Puzzle.defaults.selectedClass);
                            parentCell.removeClass(Puzzle.defaults.selectedGroupClass);
                        });
                    },
                    Cancel: function () {
                       //close
                    }
                }
            });
            //GS BUG# 2314
            
//            if (confirm("Are you sure you want to clear the puzzle?")) {
//
//                TrackPuzzle.sendPuzzleStatistics(true);
//
//                if(puzzleTimer)
//                    puzzleTimer.reset();
//                
//                GameState.clearGameState();
//                $(Puzzle.defaults.cellsId).not(Puzzle.defaults.hintCellId).children(Puzzle.defaults.cellInputId).each(function() {
//                    $(this).html("");
//                    var parentCell = $(this).parents(Puzzle.defaults.cellsId);
//                    parentCell.removeClass(Puzzle.defaults.invalidCellClass);
//                    parentCell.removeClass(Puzzle.defaults.selectedClass);
//                    parentCell.removeClass(Puzzle.defaults.selectedGroupClass);
//                });
//            }
        });
    },
    saveCrossword: function () {
        var cookieString = "";
        var cells = $(Puzzle.defaults.gridId).find(Puzzle.defaults.cellsId);

        if (!Crossword.checkAnswers())
        {
            for (var i = 0; i < cells.length; i++)
            {
                if ($(cells[i]).hasClass(Puzzle.defaults.blankClass))
                {
                    cookieString += this.defaults.blankAnswer;
                } else
                {
                    var cellInput = $(cells[i]).children(Puzzle.defaults.cellInputId).html();

                    if (cellInput && cellInput.length > 0)
                        cookieString += cellInput[0];
                    else
                        cookieString += this.defaults.blankAnswer;
                }
            }
            //Set cookie
            this.setGameState(cookieString);

            //Notify user that game is saved
            $(this.defaults.gameStateLabel).html("Game saved");

            //Clear any existing timeout functions
            if (this.defaults.timeoutId)
                clearTimeout(this.defaults.timeoutId);

            //Set timeout to clear content
            setTimeout(function () {
                $(SaveCs.defaults.gameStateLabel).html("");
            }, SaveCs.defaults.timeoutDuration);
        }
    },
    loadCrossword: function () {
        var cookieString = this.getGameState();
        var cells = $(Puzzle.defaults.gridId).find(Puzzle.defaults.cellsId);

        if (cookieString && cookieString.length)
        {
            for (var i = 0; i < cookieString.length; i++)
            {
                if (cookieString[i] == this.defaults.blankAnswer)
                    $(cells[i]).children(Puzzle.defaults.cellInputId).html("");
                else
                    $(cells[i]).children(Puzzle.defaults.cellInputId).html(cookieString[i]);
            }
        }
    }
});