/**
 * Main puzzle javascript file.
 */
var acrossScroll;
var downScroll;
// Nicescroll Settings & Events
var scrollSettings =
        {
            background: "#c5c5c5",
            cursoropacitymin: 0.3,
            cursoropacitymax: 0.8,
            cursorwidth: "8px",
            scrollspeed: 100,
            autohidemode: true,
            touchbehavior: isClientMobile,
            usetransition: false,
            hwacceleration: true,
            enabletranslate3d: isClientMobile,
            preservenativescrolling: true
        };

//Code block to fix mobile UX
var zoomLevel = 1;
var isCluesToRight = true;
var resizeMe;

$(document).ready(function() {
    $(window).resize(function() {
        clearTimeout(resizeMe);
    
        resizeMe = setTimeout(function() {
            updateCrosswordOrientation();
        }, 100);
    });

    
    window.onorientationchange = function() {
        updateCrosswordOrientation();
    };

    function updateCrosswordOrientation()
    {
        if (isClientMobile)
        {
            if (window.orientation == 0 || window.orientation == 180)
                document.getElementById("viewport").setAttribute("content", "width=device-width, maximum-scale=1.0, initial-scale=1.0, user-scalable=no");
            else
                document.getElementById("viewport").setAttribute("content", "width=device-height, maximum-scale=1.0, initial-scale=1.0, user-scalable=no");
        }
    
        resizePuzzle();
    }

    setTimeout(function() {
        downScroll = $('.down').niceScroll('.clues-down', scrollSettings);
        acrossScroll = $('.across').niceScroll('.clues-across', scrollSettings);
    }, 1000);

    var cluesMax = parseInt($('.clues').css('width'));
    function resizePuzzle(opts)
    {
        $(".puzzle").hide();
        var cellAmount = $('#puzzle-grid').data('x');
        var defaultOptions = {
            cells: cellAmount
        };
        if (typeof opts === 'object') {
            opts = $.extend(defaultOptions, opts);
        } else {
            opts = defaultOptions;
        }
        //Puzzle grid size
        var puzzleMax = (parseInt($('.cell').css('width')) * opts.cells) + cluesMax + 15;
        //Handle iPad portrait mode
        if (isClientiPad && $(".puzzle").hasClass("cells19")) {
            if (window.orientation === 0 || window.orientation === 180)
                cluesMax = 170;
            else
                cluesMax = 200;

            puzzleMax = (parseInt($('.cell').css('width')) * opts.cells) + cluesMax + 15;//(parseInt($('#puzzle-grid').css('width')) + cluesMax) + 15;
        }

        var width = (window.innerWidth / opts.cells);
        var oddSizeMargin = (opts.cells & 1) ? 2 : 1;
        var size = (Math.floor(width) - oddSizeMargin);
        size = Math.min(size, 30);

        //alert("puzzle size: " + parseInt($('.cell').css('width')) * opts.cells);
        //console.log('puzzleMax: ' + puzzleMax + ', cluesMax: ' + cluesMax + ', cellAmount: ' + cellAmount + ', cells: ' + opts.cells + ', cellSize: ' + size);
        //alert('puzzleMax: ' + puzzleMax + ', cluesMax: ' + cluesMax + ', cellAmount: ' + cellAmount + ', cells: ' + opts.cells + ', cellSize: ' + size);
        //alert(window.screen.availWidth);

        var breakPoint = (isCluesToRight) ? puzzleMax : (puzzleMax - cluesMax);

        zoomLevel = (window.innerWidth / breakPoint) - 0.035; // some margin to the right side
        var realZoomLevel = zoomLevel;
        zoomLevel = (0.7 > zoomLevel) ? 0.7 : zoomLevel; // minimum zoom 0.7
        zoomLevel = (zoomLevel > 1) ? 1 : zoomLevel; // max zoom 1
        var fontTopMargin = (zoomLevel * 6) * 0.7;

        if (window.innerWidth > puzzleMax) {
            isCluesToRight = true;
            $('#puzzle-grid').css({
                'float': 'left'
            });

            $('.clues').css({
                'float': 'left',
                'width': cluesMax,
                'margin': '0'
            });

            $('.puzzle-wrapper').css({
                width: puzzleMax
            });
        }
        else {
            isCluesToRight = false;
            $('#puzzle-grid').css({
                'float': 'none'
            });
            $('.puzzle-wrapper').css({
                'width': 'auto'
            });

            // Temp...
/*            $('.puzzle-wrapper').css({
                width: puzzleMax
            }); */
        }

        var puzzleWidthD = (isCluesToRight) ? puzzleMax : ((size * opts.cells) + 1);

        $('#puzzle-grid .cell').css(
                {
                    'width': size,
                    'height': size,
                    'lineHeight': (size + 'px')
                });

        $('.crossword-image').each(function() {
            $(this).width(size * $(this).data('width') - 1);
            $(this).height(size * $(this).data('height') - 1);
        });

        $('.puzzle').css({
            'width': puzzleWidthD
        });

        if (zoomLevel < 1) {
            $('#puzzle-grid .cell-number, #puzzle-grid .cell-input').css({
                'zoom': zoomLevel
            });
        }
        else {
            $('#puzzle-grid .cell-number').css({
                'zoom': 1
            });
        }
        if (6 > realZoomLevel) {
            $('#puzzle-grid .cell-number').css({
                'top': -fontTopMargin
            });
        }
        else {
            $('#puzzle-grid .cell-number').css({
                'top': -8
            });
        }

        $(".puzzle").show();
        if (!isCluesToRight) {
            var newPuzzleSize = parseInt($('#puzzle-grid').css('width'));
            $('.clues').css({
                'float': 'none',
                'width': (newPuzzleSize - 40),
                'margin': '0 20px'
            });
        }

        if (opts.cells >= 19)
        {
            var imageSize = (size * 5);
            var imagePos = (size * 7);
            $('#puzzle-grid .center-image').css(
                    {
                        'width': (imageSize - 1),
                        'height': (imageSize - 1),
                        'top': imagePos,
                        'left': imagePos
                    });
        }

        if (downScroll) {
            downScroll.resize();
        }

        if (acrossScroll) {
            acrossScroll.resize();
        }

        if (Puzzle.repositionUserInputField) {
            Puzzle.repositionUserInputField();
        }

        Crossword.fixHeightHTCAndroid();
    }

    resizePuzzle();
/*    var resizeMe;

    $(window).resize(function()
    {
        //Let's make sure we only run th function once after a 100 ms timeout (cheap onResizeEnd)
        clearTimeout(resizeMe);
        resizeMe = setTimeout(resizePuzzle, 500);
    }); */

    //Zoom buttons
    setTimeout(function() {
        $(Crossword.defaults.zoomInButton).click(function() {
            var zoomLevel = parseFloat($(Puzzle.defaults.gridId).css("zoom"));
            resizePuzzle();
        });
        
        $(Crossword.defaults.zoomOutButton).click(function() {
            var zoomLevel = parseFloat($(Puzzle.defaults.gridId).css("zoom"));
            
            if (!zoomLevel || zoomLevel.length == 0)
                zoomLevel = 1;
            
            if (zoomLevel > 1) {
                zoomLevel -= 0.1;
                $(Puzzle.defaults.gridId).css("zoom", zoomLevel);
            }
        });
    }, 10);
});