/*jshint supernew: true */
var puzzleTimer = new function() {
    "use strict";
    var puzzleTimerElement = $("#timer");
    var isCounting = false;
    var isCountdown = false;

    var init = function() {
        isCounting = true;
        isCountdown = false;
        if(puzzleTimerElement.timer)
        {
            puzzleTimerElement.timer('start');
        }
    }();

    this.setTime = function(start) {
        var startTime  = start || false;
        isCounting = true;
        isCountdown = false;
        if (startTime) {
            puzzleTimerElement.timer('start', {
                seconds: startTime
            });
        }
        else {
            puzzleTimerElement.timer('start');
        }
        return true;
    };

    this.setCountdown = function(time, callback) {

        isCounting = true;
        isCountdown = true;

        var obj = {};

        if(time)
            obj.seconds = time;

        if(callback)
            obj.countdownCallback = callback;

        puzzleTimerElement.timer('countdown', obj);
        
        return true;
    }; 

    this.setCallback = function(callback) {

        puzzleTimerElement.timer('countdown', {
            countdownCallback: callback
        });
    };
    
    this.getTimestamp = function () {
        var time = puzzleTimerElement.timer('get_formated_time');
//        console.log("getTimestamp: " + time);
        return time;
    };
    
    this.getFormattedTimeString = function() {
        var time = puzzleTimerElement.timer('get_formatted_time_string');
//        console.log("getFormattedTimeString: " + time);
        return time;
    };
    
    this.getSeconds = function () {
        var time = puzzleTimerElement.timer('get_seconds');
//        console.log("getSeconds: " + time);
        return time;
    };
    
    this.stop = function() {
        isCounting = false;
        puzzleTimerElement.timer('pause');
        return true;
    };
    
    this.resume = function() {
        isCounting = true;
        puzzleTimerElement.timer('resume');
        return true;
    };
    
    this.reset = function() {
        puzzleTimerElement.timer('reset');
        puzzleTimerElement.timer('start');
        return true;
    };
    
    this.addSeconds = function(seconds) {
        var currentValue = this.getSeconds();

        if (seconds)
        {
            if(isCountdown)
            {
                currentValue -= seconds;
            }
            else
            {
                currentValue += seconds;
            }
        }
        
        if(isCountdown)
        {
            this.setCountdown(currentValue);
        }
        else
        {
            this.setTime(currentValue);
        }
        
        return true;
    };
    
    this.isCounting = function() {
        return isCounting;
    };

    this.isCountdown= function() {
        return isCountdown;
    };

    this.flashWhenLow = function(seconds)
    {
        puzzleTimerElement.timer('flash_when_low', {flash_when_low: seconds});
    }
}();
