var SaveCw = $.extend(GameState, {
    init: function (cookieId) {
        //Set storage identifier
        this.setCookieIdentifier(cookieId);

        //Load codeword game
        this.loadCodeword();

        //Bind functionality to save button
        $(this.defaults.saveButton).click(function () {
            SaveCw.saveCodeword();
        });

        //"CLEAR ALL" BUTTON CLICK
        $(Puzzle.defaults.clearButton).click(function () {
            SaveCw.clearCodeword();
        });
    },
    clearCodeword: function () {
        //GS BUG# 2314
        $.confirm({
            title: '',
            content: 'Are you sure you want to clear the puzzle?',
            buttons: {
                Ok: function () {
                    TrackPuzzle.sendPuzzleStatistics(true);
                    GameState.clearGameState();

                    if (puzzleTimer)
                        puzzleTimer.reset();

                    //Clear cells
                    $(Puzzle.defaults.cellsId).each(function () {
                        if (!$(this).hasClass(Puzzle.defaults.hintCellClass))
                            $(this).children(Puzzle.defaults.cellInputId).html("");

                        $(this).removeClass(Puzzle.defaults.invalidCellClass);
                        $(this).removeClass(Puzzle.defaults.selectedClass);
                        $(this).removeClass(Puzzle.defaults.selectedGroupClass);
                    });

                    //Clear legend cells & letter key
                    $(Puzzle.defaults.legendCellId).not(Puzzle.defaults.hintCellId).children(Codeword.defaults.cellInputId).html("");
                    $(Puzzle.defaults.letterKeyCellId).not(Puzzle.defaults.hintCellId).removeClass(Codeword.defaults.inactiveCellClass);
                },
                Cancel: function () {
                    //close
                }
            }
        });
        //GS BUG# 2314
        
//        if (confirm("Are you sure you want to clear the puzzle?")) {
//            TrackPuzzle.sendPuzzleStatistics(true);
//            GameState.clearGameState();
//
//            if(puzzleTimer)
//                puzzleTimer.reset();
//
//            //Clear cells
//            $(Puzzle.defaults.cellsId).each(function() {
//                if (!$(this).hasClass(Puzzle.defaults.hintCellClass))
//                    $(this).children(Puzzle.defaults.cellInputId).html("");
//
//                $(this).removeClass(Puzzle.defaults.invalidCellClass);
//                $(this).removeClass(Puzzle.defaults.selectedClass);
//                $(this).removeClass(Puzzle.defaults.selectedGroupClass);
//            });
//
//            //Clear legend cells & letter key
//            $(Puzzle.defaults.legendCellId).not(Puzzle.defaults.hintCellId).children(Codeword.defaults.cellInputId).html("");
//            $(Puzzle.defaults.letterKeyCellId).not(Puzzle.defaults.hintCellId).removeClass(Codeword.defaults.inactiveCellClass);
//        }
    },
    saveCodeword: function () {

        if (!Codeword.checkAnswers())
        {
            var cookieString = "";
            var cells = $(Puzzle.defaults.gridId).find(Puzzle.defaults.cellsId);

            for (var i = 0; i < cells.length; i++)
            {
                if ($(cells[i]).hasClass(Puzzle.defaults.blankClass))
                {
                    cookieString += this.defaults.blankAnswer;
                } else
                {
                    var cellInput = $(cells[i]).children(Puzzle.defaults.cellInputId).html();

                    if (cellInput && cellInput.length > 0)
                        cookieString += cellInput[0];
                    else
                        cookieString += this.defaults.blankAnswer;
                }
            }

            //Set cookie
            this.setGameState(cookieString);

            //Notify user that game is saved
            $(this.defaults.gameStateLabel).html("Game saved");

            //Clear any existing timeout functions
            if (this.defaults.timeoutId)
                clearTimeout(this.defaults.timeoutId);

            //Set timeout to clear content
            setTimeout(function () {
                $(SaveCw.defaults.gameStateLabel).html("");
            }, SaveCw.defaults.timeoutDuration);
        }
    },
    loadCodeword: function () {
        var cookieString = this.getGameState();
        var cells = $(Puzzle.defaults.gridId).find(Puzzle.defaults.cellsId);

        if (cookieString && cookieString.length)
        {
            for (var i = 0; i < cookieString.length; i++)
            {
                if (cookieString[i] == this.defaults.blankAnswer)
                {
                    $(cells[i]).children(Puzzle.defaults.cellInputId).html("");
                } else
                {
                    $(cells[i]).children(Puzzle.defaults.cellInputId).html(cookieString[i]);
                    $(cells[i])

                    //Fill in the legend cells
                    var cellNumber = $(cells[i]).data("number");
                    $(Puzzle.defaults.legendId).find(".number" + cellNumber).children(Codeword.defaults.cellInputId).html(cookieString[i]);

                    //Fill in the letter key
                    $(Puzzle.defaults.letterKeyId + " .letter" + cookieString[i]).addClass(Puzzle.defaults.hintCellClass);
                    $(Puzzle.defaults.letterKeyId + " .letter" + cookieString[i]).addClass(Puzzle.defaults.inactiveCellClass);
                }
            }
        }
    }
});